#!/usr/bin/env bash

# Convenience wrapper to run the flip‑count simulator and then launch the
# lattice gauge pipeline.  This script assumes that this repository lives
# alongside ``ar-operator-core`` and ``vol4-discrete-gauge-wilson-loop``.
# Paths are resolved relative to the parent directory.

set -euo pipefail

# Determine the parent directory (workspace root)
ROOT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && cd .. && pwd)"

echo "[bootstrap] Running flip‑count simulator"
python "$ROOT_DIR/vol4-flip-count-simulator/scripts/generate_flip_counts.py"

echo "[bootstrap] Running Wilson‑loop pipeline"
python "$ROOT_DIR/vol4-wilson-loop-pipeline/run_simulation.py" --config "$ROOT_DIR/vol4-wilson-loop-pipeline/config.yaml"

echo "[bootstrap] Complete"